  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Spa Heater Controller
  ' Phil Porritt, April 9th 2016
  '
  ' Derived from Geoff Graham's Garage Park Assistant
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  Option Autorun On
  Option Explicit
  Option Default None
  
  RTC Gettime
  Dim Integer key_coord(4, 5)
  Dim String key_caption(4)
  Dim Float greent, yellowt, redt, timeout, offset
  Dim Float nbr, i, d, darray(5), dtime(3)
  Dim Float yellowtempt, redtempt
  Dim Integer c, clast
  Dim string PumpStat
  dim float TmpCur, TmpTar, TmpDif, TmpInp, TmpOut
  
  'Dim OW1,OW2,OW3,OW4,OW5,OW6,OW7,OW8
  Dim float LTemp, HTemp, Value, Status
  
  'I/O Pins in use
  dim float PinTmp=22
  dim float PinLed1=26
  'PinTmp = 22
  
  setpin(PinLed1),dout  
  
  'Restore the settings.  'These defaults are used after updating Micro
  Var Restore
  If TmpTar=0 And TmpDif=0 Then
    TmpTar = 27
    TmpDif = 1.0
    redt = 300
    timeout = 20
    offset = 5
  EndIf
  
  ' initialise some variables
  clast = 0
  yellowtempt = yellowt : redtempt = redt
  
  CLS
  
  ' This is the main processing loop
  ' Keep looping while getting the temperature and updating the display
  
  
  Do
    Watchdog 2000     ' reset after 2 second if the program stops
    
    '  TEMPR START 22, 3 ''''''Old Temperature Command
    '  TmpCur=TEMPR(22)
    
    ' if the display is touched then set the options
    If Touch(x) <> -1 Then clast = 0 : GetOptions

'Re-Sync with RTC every hour.    
    if mid$(time$,4,4)="00:0" then 
      rtc gettime    
      Print "Clock Resync'd"
    Endif
    
    
    ' Get the temperatures using Multi device read routine
      GetTemps
    
    If TmpCur<(TmpTar - TmpDif) Then
      PumpStat="Running" 'Turn the Pump on.
      pin(PinLed1)=1
    else if TmpCur>(TmpTar) then
     PumpStat="Standby" 'Turn the Pump off.
      pin(PinLed1)=0
    endif
    
    Text MM.HRes/40, MM.VRes*1/8, "Current Temp", LM, 2, 1, RGB(Green)
    Text MM.HRes/40, MM.VRes*2/8, "Target Temp", LM, 2, 1, RGB(Cyan)
    Text MM.HRes/40, MM.VRes*3/8, "Input Temp", LM, 2, 1, RGB(Blue)
    Text MM.HRes/40, MM.VRes*4/8, "Output Temp", LM, 2, 1, RGB(Red)
    Text MM.HRes/40, MM.VRes*5/8, "Time", LM, 2, 1, RGB(white)
    Text MM.HRes/2, MM.VRes*7/8, PumpStat, CM, 2, 1, RGB(Green)
    
    Text MM.HRes*39/40, MM.VRes*1/8, STR$(TmpCur,0,1), RM, 2, 1, RGB(Green)
    Text MM.HRes*39/40, MM.VRes*2/8, STR$(TmpTar,0,1), RM, 2, 1, RGB(Cyan)
    Text MM.HRes*39/40, MM.VRes*3/8, STR$(TmpInp,0,1), RM, 2, 1, RGB(Blue)
    Text MM.HRes*39/40, MM.VRes*4/8, STR$(TmpOut,0,1), RM, 2, 1, RGB(Red)
    Text MM.HRes*39/40, MM.VRes*5/8, Time$, RM, 2, 1, RGB(white)
    Text MM.HRes/2, MM.VRes*7/8, PumpStat, CM, 2, 1, RGB(Green)
    
    Print CHR$(27)+"[f"; : Print CHR$(27)+"[2J";
    Print "Current Temp", TmpCur
    Print "Target Temp ", TmpTar
    Print "Input Temp  ", TmpInp
    Print "Output Temp ", TmpOut
    Print "Pump is",PumpStat
    
  EndIf
  
  Continue Do
EndIf

d = d - offset
If d < 0 Then d = 0

' this sets the colour based on the distance and configured thresholds
''  Select Case Cint(d)
''   Case > yellowtempt
''      c = RGB(green)
''      yellowtempt = yellowt
''   Case > redtempt
''      c = RGB(yellow)
''      yellowtempt = yellowt + 1
''      redtempt = redt
''    Case Else
''      c = RGB(red)
''      redtempt = redt + 1
''  End Select

' if the colour has changed since the last time around completely
' redraw the screen
''  If c <> clast Then
''    CLS c
''    clast = c
''  EndIf

' display the distance
''    Text MM.HRes/2, MM.VRes/2, " " + Str$(Cint(d)) + " ", CM, 3, 3, 0, c
Loop

'========================OneWire Temperature Subs=============================
' Get the temperatures from multiple probes on a single pin
' Device Serial# & CRC is hard coded
' Code provided by Matherp
'=============================================================================

Sub GetTemps

OneWire Reset PinTmp

'Put 1st sensor serial and crc here &H55,&H28,XX,XX,XX,XX,XX,XX,XX,&H44
OneWire Write PinTmp, 1, 10, &H55,&H28,&H24,&H72,&H4A,&H07,&H00,&H00,&H1B,&H44
StatusCheck               'check sensor is ready
OneWire Write PinTmp, 1, 10, &H55,&H28,&H24,&H72,&H4A,&H07,&H00,&H00,&H1B,&HBE
OneWire Read PinTmp, 2, 2, LTemp, HTemp

TempCalc               'Work out the temp in C
TmpCur=Value

'Put 2nd sensor serial and crc here
OneWire Write PinTmp, 1, 10, &H55,&H28,&HC9,&H5D,&H4B,&H07,&H00,&H00,&H60,&H44
StatusCheck              'check sensor is ready
OneWire Write PinTmp, 1, 10, &H55,&H28,&HC9,&H5D,&H4B,&H07,&H00,&H00,&H60,&HBE
OneWire Read PinTmp, 2, 2, LTemp, HTemp

TempCalc               'Work out the temp in C
TmpInp=Value

'Put 3rd sensor serial and crc here
OneWire Write PinTmp, 1, 10, &H55,&H28,&H46,&HB9,&H4A,&H07,&H00,&H00,&HE4,&H44
StatusCheck              'check sensor is ready
OneWire Write PinTmp, 1, 10, &H55,&H28,&H46,&HB9,&H4A,&H07,&H00,&H00,&HE4,&HBE
OneWire Read PinTmp, 2, 2, LTemp, HTemp

TempCalc               'Work out the temp in C
TmpOut=Value

End sub
'=============================================================================
Sub StatusCheck
Timer=0 : Status=0
Do
  If Timer > 1000 Then Error "Sensor Error"
  OneWire Read PinTmp, 4, 1, Status   ' Conversion status
Loop Until Status = 1
End Sub

'=============================================================================
Sub TempCalc
Value = ((HTemp And &b111) * 256 + LTemp) / 16
If HTemp And &b1000 Then Value = -Value  ' adjust if negative
End Sub
'===========================End of Temp Routines==============================

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' routines to draw the option pages and get any changes
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' get the first page of options (timeout, offset and call GetThresholds)
Sub GetOptions
CLS
Watchdog 600000      ' restart program after 10 minutes if no key pressed

Do While Touch(x) <> -1 : Loop
Do
  CLS
  ' draw the options and the change button
  DrawOption 0, RGB(240, 240, 240), "TARGET TEMPERATURE", 0, TmpTar, "Deg"
  DrawOption 1, RGB(250, 192, 250), "TEMPERATURE DIFF", 70, TmpDif, "Deg"
  DrawOption 2, RGB(192, 250, 192), "OTHER THRESHOLDS", 137, greent, Str$(yellowt) + " " + Str$(redt)
  
  ' draw the FINISHED button at the bottom of the screen
  Line 0, 200, MM.HRes, 200, 1, RGB(210, 210, 210)
  key_coord(3,0) = MM.HRes/4 : key_coord(3,1) = 205
  key_coord(3,2) = MM.HRes/2 : key_coord(3,3) = 34
  key_coord(3,4) = RGB(cyan)
  key_caption(3) = "FINISHED"
  DrawButton 3, 0
  
  ' get the selected button and take action based on the button
  Select Case CheckButtonPress(0, 3)
    Case 0
      nbr = TmpTar
      GetFloat "TARGET TEMP", nbr
      TmpTar = nbr
    Case 1
      nbr = offset
      GetFloat "DIFFERENTIAL", nbr
      TmpDif = nbr
    Case 2
      GetThresholds
    Case 3
      Var Save TmpTar, TmpDif
      CLS
      Exit Sub
  End Select
Loop
End Sub

' get the second page of options (the three colour thresholds)
Sub GetThresholds
CLS
Watchdog 600000      ' restart program after 10 minutes if no key pressed

Do While Touch(x) <> -1 : Loop
Do
  CLS
  
  DrawOption 0, RGB(192, 250, 192), "AIR TEMPERATURE", 0, greent, "Deg"
  DrawOption 1, RGB(250, 250, 150), "PANEL DIFFERENTIAL", 70, yellowt, "Deg"
  DrawOption 2, RGB(250, 192, 192), "SOLAR ENERGY", 137, redt, "W/Sqm"
  
  ' draw the FINISHED button at the bottom of the screen
  Line 0, 200, MM.HRes, 200, 1, RGB(210, 210, 210)
  key_coord(3,0) = MM.HRes/4 : key_coord(3,1) = 205
  key_coord(3,2) = MM.HRes/2 : key_coord(3,3) = 34
  key_coord(3,4) = RGB(cyan)
'  key_caption(3) = "FINISHED"
  key_caption(3) = "PAGE - 2"

  DrawButton 3, 0
  
  ' get the selected button and take action based on the button
  Select Case CheckButtonPress(0, 3)
    Case 0
      nbr = greent
      GetFloat "AIR TEMP", nbr
      greent = nbr
    Case 1
      nbr = yellowt
      GetFloat "PANEL DIFF", nbr
      yellowt = nbr
      '        EndIf
    Case 2
      nbr = redt
      GetFloat "SOLAR ENERGY", nbr
      redt = nbr
      '        EndIf
    Case 3
      Var Save greent, yellowt, redt, offset, timeout
      GetThresholds2
      Exit sub
  End Select
Loop
End Sub

Sub GetThresholds2
  CLS
  Watchdog 600000      ' restart program after 10 minutes if no key pressed

  Do While Touch(x) <> -1 : Loop
  Do
    CLS

    DrawOption 0, RGB(192, 250, 192), "PAGE 2 OPTION 1", 0, greent, "Deg"
    DrawOption 1, RGB(250, 250, 150), "PAGE 2 OPTION 2", 70, yellowt, "Deg"
    DrawOption 2, RGB(250, 192, 192), "PAGE 2 OPTION 3", 137, redt, "W/Sqm"

    ' draw the FINISHED button at the bottom of the screen
    Line 0, 200, MM.HRes, 200, 1, RGB(210, 210, 210)
    key_coord(3,0) = MM.HRes/4 : key_coord(3,1) = 205
    key_coord(3,2) = MM.HRes/2 : key_coord(3,3) = 34
    key_coord(3,4) = RGB(cyan)
    key_caption(3) = "FINISHED"
    DrawButton 3, 0

    ' get the selected button and take action based on the button
    Select Case CheckButtonPress(0, 3)
      Case 0
        nbr = greent
        GetFloat "Page2Opt1", nbr
          greent = nbr

      Case 1
        nbr = yellowt
        GetFloat "Page2Opt2", nbr
          yellowt = nbr

      Case 2
        nbr = redt
        GetFloat "Page2Opt3", nbr
          redt = nbr

      Case 3
        Var Save greent, yellowt, redt, offset, timeout
        Exit Sub

    End Select
  Loop
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Draw options and get button presses
' These two subs draw the option title, value and a button labeled "CHANGE"
' The function CheckButtonPress() will check if a button has been touched.
'
' These routines use the arrays key_coord() and key_caption() to track the
' coordinates and size of each button and save its caption.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' draw a single option
Sub DrawOption n As Integer, colour As Integer, caption As String, vert As Integer, var As Float, units As String
Const btn_width = 120
Const fonth = MM.FontHeight * 2
Const space = 4
Text MM.HRes/2, vert, caption, CT, 2, 1, colour
If var <> -1 Then Text MM.HRes/2 - 20, vert + fonth + space, Str$(var) + " " + units, RT, 2, 1, colour
key_coord(n,0) = MM.HRes/2 + 20 : key_coord(n,1) = vert + fonth + space/2
key_coord(n,2) = btn_width : key_coord(n,3) = fonth + space
key_coord(n,4) = RGB(cyan)
key_caption(n) = "CHANGE"
DrawButton n, 0
End Sub

' draw a button
Sub DrawButton n As Integer, pressed As Integer
If pressed Then
  ' draw in reverse video if it is being touched
  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), key_coord(n,4)
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, 2, 1, 0, key_coord(n,4)
Else
  ' otherwise draw a normal button
  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), 0
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, 2, 1, key_coord(n,4), 0
EndIf
End Sub

' check if a button has been touch and animate the button's image
' returns the buttin number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
Local Integer keydwn, xt, yellowt, n
keydwn = 0

' keep looping while waiting for a press and release
Do
  If Touch(x) <> -1 And Not keydwn Then
    ' we have a touch
    xt = Touch(x)
    yellowt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yellowt > key_coord(n,1) And yellowt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        Watchdog 600000      ' restart program after 10 minutes if no further key presses
        DrawButton n, 1
        keydwn = 1
        Exit For
      EndIf
    Next n
  EndIf
  
  ' if a button is currently down check if it has been released
  If Touch(x) = -1 And keydwn Then
    ' yes, the button has been released
    ' draw the button as normal (ie, not pressed)
    DrawButton n, 0
    CheckButtonPress = n
    ' return with the button's number
    Exit Function
  EndIf
Loop
End Function


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' the next two subroutines are responsible for drawing the keypad,
' animating the key presses and returning the entered value as a float.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Get a number
' when the user touches ENT (enter) the value is saved into the variable var
' which is parsed as reference as the second argument
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub GetFloat caption As String, var As Float
Const bw = MM.HRes\4, bh = MM.VRes\5
' these are the captions on each key
Local String cap(15) = ("7","8","9","","4","5","6","","1","2","3","Can",".","0","Del","ENT")
Local Integer key, keydwn
Local Integer x, y, xt, yellowt, btn
Local String s

CLS 0
' draw the title
Text 0, 8, caption + ": ", , 2, 1, RGB(yellow), 0

' draw the entire keypad (99 means draw them all)
DrawKeypad 99

Do
  If Touch(x) <> -1 And Not keydwn Then
    ' if the panel is touched
    keydwn = 1
    xt = Touch(x)
    yellowt = Touch(y)
    btn = 1
    For y = bh To MM.VRes - bh Step bh
      For x = 0 To MM.HRes - bw Step bw
        If cap(btn-1) <> "" And xt > x And xt < x+bw And yellowt > y And yellowt < y+bh Then
          x = 1000 : y = 1000     ' exit both loops
        Else
          btn = btn + 1
        EndIf
      Next x
    Next y
    ' continue looping if the touch was not on a key
    If btn > 16 Then Continue do
    
    ' special handling for the +, - and . keys
    If (btn = 4 Or btn = 8) And s <> "" Then Continue do
    If btn = 13 And Instr(s, ".") > 0 Then Continue do
    
    ' draw the key as pressed
    DrawKeypad btn
    
    ' special processing for Can (cancel), Del and Ent (enter)
    If btn = 12 Or btn = 16 Then Continue do
    If btn = 15 Then
      If s <> "" Then s = Left$(s, Len(s) - 1)
    Else
      s = s + cap(btn - 1)    ' add the key to our entered string
    EndIf
    Text Len(caption + ": ") * 16, 8, s + " ", , 2, 1, RGB(yellow), 0
  EndIf
  
  ' if a key is currently down check if it has been released
  If Touch(x) = -1 And keydwn Then
    ' yes, the key has been released
    ' draw the key as normal (ie, not pressed)
    keydwn = 0
    DrawKeypad -btn
    ' if ENT return the value
    If btn = 16 And s <> "" Then var = Val(s)
    ' if Can just return
    If btn = 12 Or btn = 16 Then Exit Sub
  EndIf
Loop
End Sub

' this draws the keypad
' if the argument is 99 all keys will be drawn
' if it is negative the particular key will be drawn as normal
' if it is positive the key will be drawn as depressed
Sub DrawKeypad btndwn As Integer
Const bw = MM.HRes\4, bh = MM.VRes\5
Local String cap(15) = ("7","8","9","","4","5","6","","1","2","3","Can",".","0","Del","ENT")
Local Integer x, y, btn
btn = 1
For y = bh To MM.VRes - bh Step bh
  For x = 0 To MM.HRes - bw Step bw
    If cap(btn - 1) <> "" Then
      If btn = btndwn Then
        ' draw the key as touched (ie, reverse video)
        RBox x + 5, y + 5, bw - 5, bh - 5, , RGB(cyan), RGB(cyan)
        Text x + bw/2 + 4, y + bh/2 + 6, cap(btn - 1), CM, 2, 1, 0, RGB(cyan)
      ElseIf -btn = btndwn Or btndwn = 99 Then
        ' draw the key as normal
        RBox x + 5, y + 5, bw - 5, bh - 5, , RGB(cyan), 0
        Text x + bw/2, y + bh/2 + 2, cap(btn - 1), CM, 2, 1, RGB(cyan), 0
      EndIf
    EndIf
    btn = btn + 1
  Next x
Next y
End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this handy routine draws a message box with an OK button
' then waits for the button to be touched
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBox s1 As String, s2 As String
Local integer w
If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
w = w * 8     ' get the width of the text (used for the box width)

' draw the box and the message in it
RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , RGB(yellow), 0
Text MM.HRes/2, 70, s1, CT, 2, 1, RGB(white)
Text MM.HRes/2, 100, s2, CT, 2, 1, RGB(white)

' draw the OK button
RBox 110, 140, 100, 40, , RGB(cyan)
Text MM.HRes/2, 160, "OK", CM, 2, 1, RGB(cyan)

' wait for the button to be touched
Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop

' draw the OK button as depressed
RBox 110, 140, 100, 40, , RGB(cyan), RGB(cyan)
Text MM.HRes/2, 160, "OK", CM, 2, 1, 0, RGB(cyan)

' wait for the touch to be removed
Do While Touch(x) <> -1 : Loop
End Sub



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' embedded fonts
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' Font: Hom_16x24_LE
' Includes all ASCII characters
DefineFont #2
  5F201810 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 80010000 80018001
  80018001 80018001 00018001 00010001 00000000 80010000 00008001 00000000
  00000000 00000000 700E0000 700E700E 2004700E 20042004 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 20010000 20012001
  20012001 F80F2001 40024002 F01F4002 40024002 40024002 40024002 00000000
  00000000 00000000 80008000 E8018000 08041802 00040004 E0010002 08001000
  08080800 E00B100C 80008000 80008000 00000000 00000000 00070000 40108008
  40104010 1C078008 0007E000 88007038 04010401 88000401 00007000 00000000
  00000000 00000000 00000000 00000000 C004A003 00040004 00060002 20113009
  4010C010 A0086010 00001807 00000000 00000000 00000000 70000000 E0007000
  8001C000 00000001 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 10000000 20002000 40004000 80004000 80008000 80008000
  80008000 40004000 20004000 10002000 00000000 00000000 00080000 00040004
  00020002 00010002 00010001 00010001 00010001 00020002 00040002 00080004
  00000000 00000000 80000000 80008000 F007980C 6003C001 180C3006 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  80008000 80008000 FC1F8000 80008000 80008000 00008000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 00038003 00040006 00000000 00000000 00000000 00000000
  00000000 00000000 FC1F0000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 08000000 10000800
  20001000 40002000 80004000 00018000 00020001 00040002 00080004 00000008
  00000000 00000000 00000000 3006C001 08081004 08080808 08080808 08080808
  08080808 30061004 0000C001 00000000 00000000 00000000 00000000 800E8001
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 200CC003 10101010 10001000 40002000 00018000
  00040002 08100008 0000F81F 00000000 00000000 00000000 00000000 3008C007
  10001000 20001000 3000C003 08000800 08000800 300C0810 0000C003 00000000
  00000000 00000000 00000000 A0006000 20012001 20042002 20082004 20102008
  2000F81F 20002000 0000F801 00000000 00000000 00000000 00000000 0008F00F
  00080008 C00B0008 1000300C 08000800 08000800 30181000 0000C007 00000000
  00000000 00000000 00000000 0003F000 00040006 E0090008 080C100A 08080808
  08080808 10060804 0000E001 00000000 00000000 00000000 00000000 1010F01F
  20002010 40002000 40004000 80004000 80008000 00010001 00000001 00000000
  00000000 00000000 00000000 2004C003 10081008 10081008 E0072004 08101008
  08100810 300C1008 0000C003 00000000 00000000 00000000 00000000 3006C001
  0808180C 08080808 28061804 0800C801 10000800 60001000 0000800F 00000000
  00000000 00000000 00000000 00000000 00000000 C001C001 0000C001 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 C001C001 00038003 00040006
  00000000 00000000 00000000 00000000 60001800 00068001 00300018 00060018
  60008001 00001800 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 0000FC3F FC3F0000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00060018 60008001 0C001800 60001800
  00068001 00000018 00000000 00000000 00000000 00000000 00000000 C0070000
  10082008 10001000 20001000 0001C000 00000001 80010000 00008001 00000000
  00000000 00000000 C0030000 1008200C 10101010 90107010 10111011 10111011
  78109010 00100010 300C0008 0000E003 00000000 00000000 00000000 C00F0000
  20024001 20022002 10041004 F80F1004 08080808 04100410 00001E3C 00000000
  00000000 00000000 00000000 F03F0000 04080808 04080408 F00F0808 04080808
  04080408 08080408 0000F03F 00000000 00000000 00000000 00000000 E4010000
  0C0C1406 00100408 00100010 00100010 04080010 18060C0C 0000E001 00000000
  00000000 00000000 00000000 E03F0000 08101810 04100410 04100410 04100410
  04100410 18100810 0000E03F 00000000 00000000 00000000 00000000 F83F0000
  08080808 80080808 800F8008 80088008 04080408 04080408 0000FC3F 00000000
  00000000 00000000 00000000 FC1F0000 04040404 40040404 C0074004 40044004
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 C8030000
  1818280C 00200810 00200020 FC200020 08100820 100C0818 0000E003 00000000
  00000000 00000000 00000000 3E3E0000 08080808 08080808 F80F0808 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 F80F0000
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 FE030000 10001000 10001000 10001000 10101000
  10101010 60082010 00008007 00000000 00000000 00000000 00000000 3C3E0000
  20081008 80084008 000B0009 4008800C 10082008 08081008 00001E3E 00000000
  00000000 00000000 00000000 803F0000 00040004 00040004 00040004 00040004
  04040404 04040404 0000FC3F 00000000 00000000 00000000 00000000 0E380000
  0C180C18 14141414 24122412 C4114411 04100410 04100410 00001E3C 00000000
  00000000 00000000 00000000 7E780000 08140818 08120812 08110811 88108810
  48104810 18102810 0000187E 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 0000E003 00000000
  00000000 00000000 00000000 F01F0000 04040804 04040404 08040404 0004F007
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 8C01E003 0000F006
  00000000 00000000 00000000 E03F0000 08081008 08080808 10080808 4008E00F
  10082008 08081008 00000E3E 00000000 00000000 00000000 00000000 C8030000
  1810280C 00100810 C003000C 08003000 08100800 10140818 0000E013 00000000
  00000000 00000000 00000000 FC1F0000 84108410 84108410 80008000 80008000
  80008000 80008000 0000F007 00000000 00000000 00000000 00000000 7C3E0000
  08100810 08100810 08100810 08100810 08100810 10080810 0000E007 00000000
  00000000 00000000 00000000 3E3E0000 04100410 08080808 10041004 20021004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 3E3E0000
  04100410 84108410 44114411 280A4809 280A280A 180C180C 0000180C 00000000
  00000000 00000000 00000000 3E3E0000 10040808 20021004 80004001 20024001
  10042002 08080808 00003E3E 00000000 00000000 00000000 00000000 1E3C0000
  10040808 20021004 40012002 80008000 80008000 80008000 0000F007 00000000
  00000000 00000000 00000000 F81F0000 10100810 40102010 80004000 00020001
  08040802 08100808 0000F81F 00000000 00000000 00000000 E0000000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 E0008000
  00000000 00000000 00080000 00040008 00020004 00010002 80000001 40008000
  20004000 10002000 08001000 00000800 00000000 00000000 80030000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 80038000
  00000000 00000000 80000000 2002C001 08081004 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  FF7F0000 00000000 80030000 C0018003 6000C000 00002000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 2008C007 10001000 3008D007 10101010 30081010 0000DC07 00000000
  00000000 00000000 00000000 00080038 00080008 0C0AF009 0208040C 02080208
  02080208 0C0A040C 0000F039 00000000 00000000 00000000 00000000 00000000
  00000000 180CE803 08100808 00100010 00100010 180C0C08 0000E003 00000000
  00000000 00000000 00000000 08003800 08000800 2818C807 08201810 08200820
  08200820 28181810 0000CE07 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 FC1F0410 00100010 0C0C0008 0000F003 00000000
  00000000 00000000 00000000 8401F800 00010001 0001F80F 00010001 00010001
  00010001 00010001 0000F80F 00000000 00000000 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 10000800
  C00F3000 00000000 00000000 00080038 00080008 100AE009 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 80000000 80008000
  00000000 80008007 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 20000000 20002000 00000000 1000F00F 10001000 10001000
  10001000 10001000 10001000 20001000 800F6000 00000000 00000000 0004001C
  00040004 20047804 80044004 00070005 40048004 10042004 00003C1C 00000000
  00000000 00000000 00000000 8000800F 80008000 80008000 80008000 80008000
  80008000 80008000 0000FC1F 00000000 00000000 00000000 00000000 00000000
  00000000 C4183877 84108410 84108410 84108410 84108410 0000C67C 00000000
  00000000 00000000 00000000 00000000 00000000 100AE039 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 04100410 04100410 180C0808 0000E003 00000000
  00000000 00000000 00000000 00000000 00000000 0C0AF039 0208040C 02080208
  02080208 0C0A040C 0008F009 00080008 003F0008 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 08000800
  7E000800 00000000 00000000 00000000 00000000 C402380E 00020003 00020002
  00020002 00020002 0000F01F 00000000 00000000 00000000 00000000 00000000
  00000000 1804E803 00040804 70008003 08000800 100C0808 0000E00B 00000000
  00000000 00000000 00000000 00040004 00040004 0004F01F 00040004 00040004
  00040004 18020004 0000E001 00000000 00000000 00000000 00000000 00000000
  00000000 08083838 08080808 08080808 08080808 28041808 0000CC03 00000000
  00000000 00000000 00000000 00000000 00000000 08083E3E 10040808 10041004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 00000000
  00000000 04101E3C 84100410 48098808 48094809 30065005 00003006 00000000
  00000000 00000000 00000000 00000000 00000000 08083C1E 20021004 80004001
  20024001 08081004 00003C1E 00000000 00000000 00000000 00000000 00000000
  00000000 08103C3C 10080810 20081008 40042004 80024002 00018001 00020001
  803F0002 00000000 00000000 00000000 00000000 0808F80F 20001008 80004000
  00020001 08080804 0000F80F 00000000 00000000 00000000 60000000 80008000
  80008000 80008000 80008000 80000003 80008000 80008000 80008000 60008000
  00000000 00000000 00000000 80000000 80008000 80008000 80008000 80008000
  80008000 80008000 80008000 80008000 00000000 00000000 00030000 80008000
  80008000 80008000 80008000 80006000 80008000 80008000 80008000 00038000
  00000000 00000000 00000000 00000000 00000000 00000000 98190C0F 0000F030
  00000000 00000000 00000000 00000000 00000000
End DefineFont
  
  
  ' ArialNumFontPlus.bas
  ' Font type    : Special (SubSet)
  ' Font size    : 32x50 pixels
  ' Memory usage : 2204 bytes
DefineFont #3
  0B303220 00000000 00000000 00F00F00 00F81F00 00FE7F00 00FFFF00 00FFFF01
  801FF803 C00FF003 C007E007 E003C007 E003C00F F001800F F001800F F001801F
  F800001F F800001F F800001F F800001F FC00003F 7C00003E 7C00003E 7C00003E
  7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003F
  F800001F F800001F F800001F F800001F F001800F F001800F F001800F E003C007
  E003C007 C007E003 C00FF003 801FF801 00FFFF00 00FEFF00 00FC7F00 00F81F00
  00E00700 00000000 00000000 00000000 00000000 00000000 00F00000 00F00100
  00F00300 00F00700 00F00F00 00F01F00 00F03F00 00F07F00 00F0FF01 00F0FD03
  00F0F10F 00F0E10F 00F0810F 00F0010F 00F0010C 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00000000 00000000 00000000 00000000 00F00F00
  00FE7F00 00FFFF01 C0FFFF03 E0FFFF03 F00FE007 F003C00F F001800F F800001F
  F800001F F800003E 7C00003E 7C00003E 7C000000 7C000000 7C000000 78000000
  F8000000 F8010000 F0030000 F0070000 E00F0000 C01F0000 803F0000 007F0000
  00FE0000 00FC0100 00F80300 00F00700 00E00F00 00C01F00 00803F00 00007F00
  0000FE00 0000FC01 0000F803 0000F007 0000E007 0000C00F 0000800F 0000801F
  FCFFFF3F FCFFFF3F FCFFFF7F FCFFFF7F FCFFFF7F 00000000 00000000 00000000
  00000000 00F00F00 00FC3F00 00FEFF00 00FFFF01 80FFFF03 C01FE003 C00FC007
  E0078007 E003800F E003000F F003000F F001000F F0030000 E0030000 E0030000
  E0070000 C00F0000 C01F0000 803F0000 00FF0700 00FF0700 00FF0700 80FF0700
  C01F0000 E00F0000 E0030000 F0010000 F0000000 F8000000 F8000000 FC000000
  FC000000 FC000000 FC00001F FC00001F F800001F F801001F F801800F F003800F
  F007C00F E00FE007 C03FFC03 80FFFF01 00FFFF00 00FC7F00 00F00F00 00000000
  00000000 00000000 00000000 000F0000 001F0000 001F0000 003F0000 003F0000
  007F0000 007F0000 00FF0000 00FF0100 00FF0100 00FF0300 00DF0700 00DF0700
  009F0F00 009F0F00 001F1F00 001F3E00 001F7E00 001F7C00 001FF800 001FF800
  001FF001 001FE003 001FE003 001FC007 001FC007 001F800F 001F801F 001F001F
  001F003E FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F 001F0000 001F0000
  001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000
  001F0000 00000000 00000000 00000000 00000000 F0FFFF01 F0FFFF01 F0FFFF01
  F0FFFF01 F0FFFF01 0000E003 0000C003 0000C003 0000C003 0000C007 0000C007
  0000C007 0000C007 00008007 0000800F 00F0800F 00FE8F0F 80FFBF0F C0FFFF0F
  E0FFFF0F F007FF1F F003E01F F801C01F F800001F F8000000 FC000000 7C000000
  7C000000 7C000000 7C000000 7C000000 7C000000 7C000000 F800003F F800003F
  F800003F F000001F F001001F E003801F E007C00F C01FE007 80FFFF03 00FFFF03
  00FEFF01 00F87F00 00E00F00 00000000 00000000 00000000 00000000 00F00F00
  00FE3F00 00FFFF00 80FFFF01 C0FFFF03 E007E007 F003C007 F001C00F F800800F
  F800801F F800801F 0000001F 0000001F 0000003F 0000003F 0000003F 00F0033F
  00FC1F3F 00FE7F3F 80FFFF3F C0FFFF3F E00FF83F F003E03F F003E03F F801C03F
  F800803F F800803F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F
  7C00001F 7800801F F800801F F800801F F800800F F001C00F F003F007 E00FF803
  C0FFFF01 80FFFF00 00FF7F00 00FC1F00 00F00300 00000000 00000000 00000000
  00000000 FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FC000000 FC000000
  F8010000 F0010000 E0030000 E0030000 C0070000 800F0000 001F0000 003E0000
  007C0000 00FC0000 00F80000 00F00000 00F00100 00F00100 00E00300 00E00300
  00E00300 00C00700 00C00700 00800F00 00800F00 00800F00 00001F00 00001F00
  00001F00 00001F00 00003E00 00003E00 00003E00 00003E00 00003E00 00007C00
  00007C00 00007C00 00007C00 00007C00 0000F800 0000F800 0000F800 00000000
  00000000 00000000 00000000 00F00F00 00FE7F00 80FFFF00 80FFFF01 C01FF803
  E007E007 E003C007 F003C00F F001800F F001800F F001800F F001800F F001800F
  F001800F E003C007 E003C007 C007E003 8007F001 003FFC00 00FF7F00 00FC3F00
  00FE7F00 00FFFF00 C0FFFF03 E00FF007 F003C00F F001800F F801801F F800001F
  F800001F 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E F800001F
  F800001F F001800F F003800F E007C007 C00FF003 80FFFF01 00FFFF00 00FC3F00
  00F00F00 00000000 00000000 00000000 00000000 00F00F00 00FC3F00 00FFFF00
  80FFFF01 C0FFFF03 E01FF803 E007E007 F007E007 F003C00F F803C00F F801801F
  F801801F FC00001F FC00001F FC00001F FC00001F FC00001F FC00001F FC01801F
  FC01801F FC03C00F FC03C00F FC07E007 FC07E007 FC1FF803 FCFFFF01 FCFFFF00
  FCFEFF00 FCF87F00 FCE01F00 FC000000 FC000000 FC000000 FC000000 F8010000
  F801003F F001003F F003001F E007801F E00FC00F C03FE00F 80FFFF07 00FFFF03
  00FEFF01 00F8FF00 00E03F00 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00E00000 00F00100 00F80300 00F80300 00F80300 00F00100 00E00000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00E00000 00F00100
  00F80300 00F80300 00F80300 00F00100 00E00000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000
End DefineFont
